import { defineAuth } from '@aws-amplify/backend';
import { env } from '../env.setup';
import { listAllUsers } from '../data/list-all-users/resource';
import { inviteUser } from '../data/invite-user/resource';
import { deleteUser } from '../data/delete-user/resource';

const AUTH_RESOURCE_NAME = `${env.BACKEND_AWS_COGNITO_RESOURCE_NAME_PREFIX}`

/**
 * Define and configure your auth resource
 * @see https://docs.amplify.aws/gen2/build-a-backend/auth
 */
export const auth = defineAuth({
  name: AUTH_RESOURCE_NAME,
  loginWith: {
    email: true,
  },
  groups: [
    env.BACKEND_AWS_COGNITO_ADMIN_GROUP_NAME,
    env.BACKEND_AWS_COGNITO_VIEWER_GROUP_NAME,
  ],
  access: (allow) => [
    allow.resource(listAllUsers).to(["listUsersInGroup"]),
    allow.resource(inviteUser).to(["createUser", "addUserToGroup"]),
    allow.resource(deleteUser).to(["deleteUser", "getUser"]),
  ],
});
